package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.LocalGatewayRoutetableId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteLocalGatewayRouteTableRequest(
    localGatewayRouteTableId: LocalGatewayRoutetableId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableRequest = {
    import DeleteLocalGatewayRouteTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableRequest
      .builder()
      .localGatewayRouteTableId(
        LocalGatewayRoutetableId.unwrap(
          localGatewayRouteTableId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteLocalGatewayRouteTableRequest.ReadOnly =
    zio.aws.ec2.model.DeleteLocalGatewayRouteTableRequest.wrap(buildAwsValue())
}
object DeleteLocalGatewayRouteTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteLocalGatewayRouteTableRequest =
      zio.aws.ec2.model
        .DeleteLocalGatewayRouteTableRequest(localGatewayRouteTableId)
    def localGatewayRouteTableId: LocalGatewayRoutetableId
    def getLocalGatewayRouteTableId
        : ZIO[Any, Nothing, LocalGatewayRoutetableId] =
      ZIO.succeed(localGatewayRouteTableId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableRequest
  ) extends zio.aws.ec2.model.DeleteLocalGatewayRouteTableRequest.ReadOnly {
    override val localGatewayRouteTableId: LocalGatewayRoutetableId =
      zio.aws.ec2.model.primitives
        .LocalGatewayRoutetableId(impl.localGatewayRouteTableId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableRequest
  ): zio.aws.ec2.model.DeleteLocalGatewayRouteTableRequest.ReadOnly =
    new Wrapper(impl)
}
