package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateNetworkInsightsAccessScopeResponse(
    networkInsightsAccessScope: Optional[
      zio.aws.ec2.model.NetworkInsightsAccessScope
    ] = Optional.Absent,
    networkInsightsAccessScopeContent: Optional[
      zio.aws.ec2.model.NetworkInsightsAccessScopeContent
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeResponse = {
    import CreateNetworkInsightsAccessScopeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeResponse
      .builder()
      .optionallyWith(
        networkInsightsAccessScope.map(value => value.buildAwsValue())
      )(_.networkInsightsAccessScope)
      .optionallyWith(
        networkInsightsAccessScopeContent.map(value => value.buildAwsValue())
      )(_.networkInsightsAccessScopeContent)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateNetworkInsightsAccessScopeResponse.ReadOnly =
    zio.aws.ec2.model.CreateNetworkInsightsAccessScopeResponse
      .wrap(buildAwsValue())
}
object CreateNetworkInsightsAccessScopeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateNetworkInsightsAccessScopeResponse =
      zio.aws.ec2.model.CreateNetworkInsightsAccessScopeResponse(
        networkInsightsAccessScope.map(value => value.asEditable),
        networkInsightsAccessScopeContent.map(value => value.asEditable)
      )
    def networkInsightsAccessScope
        : Optional[zio.aws.ec2.model.NetworkInsightsAccessScope.ReadOnly]
    def networkInsightsAccessScopeContent
        : Optional[zio.aws.ec2.model.NetworkInsightsAccessScopeContent.ReadOnly]
    def getNetworkInsightsAccessScope: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInsightsAccessScope.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkInsightsAccessScope",
      networkInsightsAccessScope
    )
    def getNetworkInsightsAccessScopeContent: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInsightsAccessScopeContent.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkInsightsAccessScopeContent",
      networkInsightsAccessScopeContent
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeResponse
  ) extends zio.aws.ec2.model.CreateNetworkInsightsAccessScopeResponse.ReadOnly {
    override val networkInsightsAccessScope
        : Optional[zio.aws.ec2.model.NetworkInsightsAccessScope.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInsightsAccessScope())
        .map(value => zio.aws.ec2.model.NetworkInsightsAccessScope.wrap(value))
    override val networkInsightsAccessScopeContent: Optional[
      zio.aws.ec2.model.NetworkInsightsAccessScopeContent.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInsightsAccessScopeContent())
      .map(value =>
        zio.aws.ec2.model.NetworkInsightsAccessScopeContent.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeResponse
  ): zio.aws.ec2.model.CreateNetworkInsightsAccessScopeResponse.ReadOnly =
    new Wrapper(impl)
}
