package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCapacityReservationResponse(
    capacityReservation: Optional[zio.aws.ec2.model.CapacityReservation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateCapacityReservationResponse = {
    import CreateCapacityReservationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateCapacityReservationResponse
      .builder()
      .optionallyWith(capacityReservation.map(value => value.buildAwsValue()))(
        _.capacityReservation
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateCapacityReservationResponse.ReadOnly =
    zio.aws.ec2.model.CreateCapacityReservationResponse.wrap(buildAwsValue())
}
object CreateCapacityReservationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateCapacityReservationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateCapacityReservationResponse =
      zio.aws.ec2.model.CreateCapacityReservationResponse(
        capacityReservation.map(value => value.asEditable)
      )
    def capacityReservation
        : Optional[zio.aws.ec2.model.CapacityReservation.ReadOnly]
    def getCapacityReservation
        : ZIO[Any, AwsError, zio.aws.ec2.model.CapacityReservation.ReadOnly] =
      AwsError.unwrapOptionField("capacityReservation", capacityReservation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateCapacityReservationResponse
  ) extends zio.aws.ec2.model.CreateCapacityReservationResponse.ReadOnly {
    override val capacityReservation
        : Optional[zio.aws.ec2.model.CapacityReservation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityReservation())
        .map(value => zio.aws.ec2.model.CapacityReservation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateCapacityReservationResponse
  ): zio.aws.ec2.model.CreateCapacityReservationResponse.ReadOnly = new Wrapper(
    impl
  )
}
