package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.BundleId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelBundleTaskRequest(bundleId: BundleId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest = {
    import CancelBundleTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest
      .builder()
      .bundleId(BundleId.unwrap(bundleId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelBundleTaskRequest.ReadOnly =
    zio.aws.ec2.model.CancelBundleTaskRequest.wrap(buildAwsValue())
}
object CancelBundleTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelBundleTaskRequest =
      zio.aws.ec2.model.CancelBundleTaskRequest(bundleId)
    def bundleId: BundleId
    def getBundleId: ZIO[Any, Nothing, BundleId] = ZIO.succeed(bundleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest
  ) extends zio.aws.ec2.model.CancelBundleTaskRequest.ReadOnly {
    override val bundleId: BundleId =
      zio.aws.ec2.model.primitives.BundleId(impl.bundleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest
  ): zio.aws.ec2.model.CancelBundleTaskRequest.ReadOnly = new Wrapper(impl)
}
