package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ByoipCidrState {
  def unwrap: software.amazon.awssdk.services.ec2.model.ByoipCidrState
}
object ByoipCidrState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ByoipCidrState
  ): zio.aws.ec2.model.ByoipCidrState = value match {
    case software.amazon.awssdk.services.ec2.model.ByoipCidrState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ByoipCidrState.ADVERTISED =>
      val r = advertised
      r
    case software.amazon.awssdk.services.ec2.model.ByoipCidrState.DEPROVISIONED =>
      val r = deprovisioned
      r
    case software.amazon.awssdk.services.ec2.model.ByoipCidrState.FAILED_DEPROVISION =>
      val r = `failed-deprovision`
      r
    case software.amazon.awssdk.services.ec2.model.ByoipCidrState.FAILED_PROVISION =>
      val r = `failed-provision`
      r
    case software.amazon.awssdk.services.ec2.model.ByoipCidrState.PENDING_DEPROVISION =>
      val r = `pending-deprovision`
      r
    case software.amazon.awssdk.services.ec2.model.ByoipCidrState.PENDING_PROVISION =>
      val r = `pending-provision`
      r
    case software.amazon.awssdk.services.ec2.model.ByoipCidrState.PROVISIONED =>
      val r = provisioned
      r
    case software.amazon.awssdk.services.ec2.model.ByoipCidrState.PROVISIONED_NOT_PUBLICLY_ADVERTISABLE =>
      val r = `provisioned-not-publicly-advertisable`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ByoipCidrState =
      software.amazon.awssdk.services.ec2.model.ByoipCidrState.UNKNOWN_TO_SDK_VERSION
  }
  case object advertised extends zio.aws.ec2.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ByoipCidrState =
      software.amazon.awssdk.services.ec2.model.ByoipCidrState.ADVERTISED
  }
  case object deprovisioned extends zio.aws.ec2.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ByoipCidrState =
      software.amazon.awssdk.services.ec2.model.ByoipCidrState.DEPROVISIONED
  }
  case object `failed-deprovision` extends zio.aws.ec2.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ByoipCidrState =
      software.amazon.awssdk.services.ec2.model.ByoipCidrState.FAILED_DEPROVISION
  }
  case object `failed-provision` extends zio.aws.ec2.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ByoipCidrState =
      software.amazon.awssdk.services.ec2.model.ByoipCidrState.FAILED_PROVISION
  }
  case object `pending-deprovision` extends zio.aws.ec2.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ByoipCidrState =
      software.amazon.awssdk.services.ec2.model.ByoipCidrState.PENDING_DEPROVISION
  }
  case object `pending-provision` extends zio.aws.ec2.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ByoipCidrState =
      software.amazon.awssdk.services.ec2.model.ByoipCidrState.PENDING_PROVISION
  }
  case object provisioned extends zio.aws.ec2.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ByoipCidrState =
      software.amazon.awssdk.services.ec2.model.ByoipCidrState.PROVISIONED
  }
  case object `provisioned-not-publicly-advertisable`
      extends zio.aws.ec2.model.ByoipCidrState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ByoipCidrState =
      software.amazon.awssdk.services.ec2.model.ByoipCidrState.PROVISIONED_NOT_PUBLICLY_ADVERTISABLE
  }
}
