package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UnsuccessfulInstanceCreditSpecificationItem(
    instanceId: Optional[String] = Optional.Absent,
    error: Optional[
      zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationItemError
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationItem = {
    import UnsuccessfulInstanceCreditSpecificationItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationItem
      .builder()
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationItem.ReadOnly =
    zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationItem
      .wrap(buildAwsValue())
}
object UnsuccessfulInstanceCreditSpecificationItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationItem =
      zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationItem(
        instanceId.map(value => value),
        error.map(value => value.asEditable)
      )
    def instanceId: Optional[String]
    def error: Optional[
      zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationItemError.ReadOnly
    ]
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationItemError.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationItem
  ) extends zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationItem.ReadOnly {
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
    override val error: Optional[
      zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationItemError.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value =>
        zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationItemError
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.UnsuccessfulInstanceCreditSpecificationItem
  ): zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationItem.ReadOnly =
    new Wrapper(impl)
}
