package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait StorageTier {
  def unwrap: software.amazon.awssdk.services.ec2.model.StorageTier
}
object StorageTier {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.StorageTier
  ): zio.aws.ec2.model.StorageTier = value match {
    case software.amazon.awssdk.services.ec2.model.StorageTier.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.StorageTier.ARCHIVE =>
      val r = archive
      r
    case software.amazon.awssdk.services.ec2.model.StorageTier.STANDARD =>
      val r = standard
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.StorageTier {
    override def unwrap: software.amazon.awssdk.services.ec2.model.StorageTier =
      software.amazon.awssdk.services.ec2.model.StorageTier.UNKNOWN_TO_SDK_VERSION
  }
  case object archive extends zio.aws.ec2.model.StorageTier {
    override def unwrap: software.amazon.awssdk.services.ec2.model.StorageTier =
      software.amazon.awssdk.services.ec2.model.StorageTier.ARCHIVE
  }
  case object standard extends zio.aws.ec2.model.StorageTier {
    override def unwrap: software.amazon.awssdk.services.ec2.model.StorageTier =
      software.amazon.awssdk.services.ec2.model.StorageTier.STANDARD
  }
}
