package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait StatusType {
  def unwrap: software.amazon.awssdk.services.ec2.model.StatusType
}
object StatusType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.StatusType
  ): zio.aws.ec2.model.StatusType = value match {
    case software.amazon.awssdk.services.ec2.model.StatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.StatusType.PASSED =>
      val r = passed
      r
    case software.amazon.awssdk.services.ec2.model.StatusType.FAILED =>
      val r = failed
      r
    case software.amazon.awssdk.services.ec2.model.StatusType.INSUFFICIENT_DATA =>
      val r = `insufficient-data`
      r
    case software.amazon.awssdk.services.ec2.model.StatusType.INITIALIZING =>
      val r = initializing
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.StatusType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.StatusType =
      software.amazon.awssdk.services.ec2.model.StatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object passed extends zio.aws.ec2.model.StatusType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.StatusType =
      software.amazon.awssdk.services.ec2.model.StatusType.PASSED
  }
  case object failed extends zio.aws.ec2.model.StatusType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.StatusType =
      software.amazon.awssdk.services.ec2.model.StatusType.FAILED
  }
  case object `insufficient-data` extends zio.aws.ec2.model.StatusType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.StatusType =
      software.amazon.awssdk.services.ec2.model.StatusType.INSUFFICIENT_DATA
  }
  case object initializing extends zio.aws.ec2.model.StatusType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.StatusType =
      software.amazon.awssdk.services.ec2.model.StatusType.INITIALIZING
  }
}
