package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SlotDateTimeRangeRequest(
    earliestTime: DateTime,
    latestTime: DateTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SlotDateTimeRangeRequest = {
    import SlotDateTimeRangeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SlotDateTimeRangeRequest
      .builder()
      .earliestTime(DateTime.unwrap(earliestTime): Instant)
      .latestTime(DateTime.unwrap(latestTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SlotDateTimeRangeRequest.ReadOnly =
    zio.aws.ec2.model.SlotDateTimeRangeRequest.wrap(buildAwsValue())
}
object SlotDateTimeRangeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SlotDateTimeRangeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SlotDateTimeRangeRequest =
      zio.aws.ec2.model.SlotDateTimeRangeRequest(earliestTime, latestTime)
    def earliestTime: DateTime
    def latestTime: DateTime
    def getEarliestTime: ZIO[Any, Nothing, DateTime] = ZIO.succeed(earliestTime)
    def getLatestTime: ZIO[Any, Nothing, DateTime] = ZIO.succeed(latestTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SlotDateTimeRangeRequest
  ) extends zio.aws.ec2.model.SlotDateTimeRangeRequest.ReadOnly {
    override val earliestTime: DateTime =
      zio.aws.ec2.model.primitives.DateTime(impl.earliestTime())
    override val latestTime: DateTime =
      zio.aws.ec2.model.primitives.DateTime(impl.latestTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SlotDateTimeRangeRequest
  ): zio.aws.ec2.model.SlotDateTimeRangeRequest.ReadOnly = new Wrapper(impl)
}
