package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{StringType, RamdiskId, KernelId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterImageRequest(
    imageLocation: Optional[String] = Optional.Absent,
    architecture: Optional[zio.aws.ec2.model.ArchitectureValues] =
      Optional.Absent,
    blockDeviceMappings: Optional[
      Iterable[zio.aws.ec2.model.BlockDeviceMapping]
    ] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    enaSupport: Optional[Boolean] = Optional.Absent,
    kernelId: Optional[KernelId] = Optional.Absent,
    name: String,
    billingProducts: Optional[Iterable[String]] = Optional.Absent,
    ramdiskId: Optional[RamdiskId] = Optional.Absent,
    rootDeviceName: Optional[String] = Optional.Absent,
    sriovNetSupport: Optional[String] = Optional.Absent,
    virtualizationType: Optional[String] = Optional.Absent,
    bootMode: Optional[zio.aws.ec2.model.BootModeValues] = Optional.Absent,
    tpmSupport: Optional[zio.aws.ec2.model.TpmSupportValues] = Optional.Absent,
    uefiData: Optional[StringType] = Optional.Absent,
    imdsSupport: Optional[zio.aws.ec2.model.ImdsSupportValues] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RegisterImageRequest = {
    import RegisterImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RegisterImageRequest
      .builder()
      .optionallyWith(imageLocation.map(value => value: java.lang.String))(
        _.imageLocation
      )
      .optionallyWith(architecture.map(value => value.unwrap))(_.architecture)
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(enaSupport.map(value => value: java.lang.Boolean))(
        _.enaSupport
      )
      .optionallyWith(
        kernelId.map(value => KernelId.unwrap(value): java.lang.String)
      )(_.kernelId)
      .name(name: java.lang.String)
      .optionallyWith(
        billingProducts.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.billingProducts)
      .optionallyWith(
        ramdiskId.map(value => RamdiskId.unwrap(value): java.lang.String)
      )(_.ramdiskId)
      .optionallyWith(rootDeviceName.map(value => value: java.lang.String))(
        _.rootDeviceName
      )
      .optionallyWith(sriovNetSupport.map(value => value: java.lang.String))(
        _.sriovNetSupport
      )
      .optionallyWith(virtualizationType.map(value => value: java.lang.String))(
        _.virtualizationType
      )
      .optionallyWith(bootMode.map(value => value.unwrap))(_.bootMode)
      .optionallyWith(tpmSupport.map(value => value.unwrap))(_.tpmSupport)
      .optionallyWith(uefiData.map(value => value: java.lang.String))(
        _.uefiData
      )
      .optionallyWith(imdsSupport.map(value => value.unwrap))(_.imdsSupport)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RegisterImageRequest.ReadOnly =
    zio.aws.ec2.model.RegisterImageRequest.wrap(buildAwsValue())
}
object RegisterImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RegisterImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RegisterImageRequest =
      zio.aws.ec2.model.RegisterImageRequest(
        imageLocation.map(value => value),
        architecture.map(value => value),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        description.map(value => value),
        enaSupport.map(value => value),
        kernelId.map(value => value),
        name,
        billingProducts.map(value => value),
        ramdiskId.map(value => value),
        rootDeviceName.map(value => value),
        sriovNetSupport.map(value => value),
        virtualizationType.map(value => value),
        bootMode.map(value => value),
        tpmSupport.map(value => value),
        uefiData.map(value => value),
        imdsSupport.map(value => value)
      )
    def imageLocation: Optional[String]
    def architecture: Optional[zio.aws.ec2.model.ArchitectureValues]
    def blockDeviceMappings
        : Optional[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]]
    def description: Optional[String]
    def enaSupport: Optional[Boolean]
    def kernelId: Optional[KernelId]
    def name: String
    def billingProducts: Optional[List[String]]
    def ramdiskId: Optional[RamdiskId]
    def rootDeviceName: Optional[String]
    def sriovNetSupport: Optional[String]
    def virtualizationType: Optional[String]
    def bootMode: Optional[zio.aws.ec2.model.BootModeValues]
    def tpmSupport: Optional[zio.aws.ec2.model.TpmSupportValues]
    def uefiData: Optional[StringType]
    def imdsSupport: Optional[zio.aws.ec2.model.ImdsSupportValues]
    def getImageLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageLocation", imageLocation)
    def getArchitecture
        : ZIO[Any, AwsError, zio.aws.ec2.model.ArchitectureValues] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.BlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEnaSupport: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enaSupport", enaSupport)
    def getKernelId: ZIO[Any, AwsError, KernelId] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getBillingProducts: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("billingProducts", billingProducts)
    def getRamdiskId: ZIO[Any, AwsError, RamdiskId] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getRootDeviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rootDeviceName", rootDeviceName)
    def getSriovNetSupport: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sriovNetSupport", sriovNetSupport)
    def getVirtualizationType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("virtualizationType", virtualizationType)
    def getBootMode: ZIO[Any, AwsError, zio.aws.ec2.model.BootModeValues] =
      AwsError.unwrapOptionField("bootMode", bootMode)
    def getTpmSupport: ZIO[Any, AwsError, zio.aws.ec2.model.TpmSupportValues] =
      AwsError.unwrapOptionField("tpmSupport", tpmSupport)
    def getUefiData: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("uefiData", uefiData)
    def getImdsSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.ImdsSupportValues] =
      AwsError.unwrapOptionField("imdsSupport", imdsSupport)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RegisterImageRequest
  ) extends zio.aws.ec2.model.RegisterImageRequest.ReadOnly {
    override val imageLocation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageLocation())
      .map(value => value: String)
    override val architecture: Optional[zio.aws.ec2.model.ArchitectureValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.architecture())
        .map(value => zio.aws.ec2.model.ArchitectureValues.wrap(value))
    override val blockDeviceMappings
        : Optional[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockDeviceMappings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.BlockDeviceMapping.wrap(item)
          }.toList
        )
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val enaSupport: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enaSupport())
      .map(value => value: Boolean)
    override val kernelId: Optional[KernelId] = zio.aws.core.internal
      .optionalFromNullable(impl.kernelId())
      .map(value => zio.aws.ec2.model.primitives.KernelId(value))
    override val name: String = impl.name(): String
    override val billingProducts: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.billingProducts())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val ramdiskId: Optional[RamdiskId] = zio.aws.core.internal
      .optionalFromNullable(impl.ramdiskId())
      .map(value => zio.aws.ec2.model.primitives.RamdiskId(value))
    override val rootDeviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.rootDeviceName())
      .map(value => value: String)
    override val sriovNetSupport: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sriovNetSupport())
      .map(value => value: String)
    override val virtualizationType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.virtualizationType())
      .map(value => value: String)
    override val bootMode: Optional[zio.aws.ec2.model.BootModeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bootMode())
        .map(value => zio.aws.ec2.model.BootModeValues.wrap(value))
    override val tpmSupport: Optional[zio.aws.ec2.model.TpmSupportValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tpmSupport())
        .map(value => zio.aws.ec2.model.TpmSupportValues.wrap(value))
    override val uefiData: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.uefiData())
      .map(value => value: StringType)
    override val imdsSupport: Optional[zio.aws.ec2.model.ImdsSupportValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imdsSupport())
        .map(value => zio.aws.ec2.model.ImdsSupportValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RegisterImageRequest
  ): zio.aws.ec2.model.RegisterImageRequest.ReadOnly = new Wrapper(impl)
}
