package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoadPermission(
    userId: Optional[String] = Optional.Absent,
    group: Optional[zio.aws.ec2.model.PermissionGroup] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LoadPermission = {
    import LoadPermission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LoadPermission
      .builder()
      .optionallyWith(userId.map(value => value: java.lang.String))(_.userId)
      .optionallyWith(group.map(value => value.unwrap))(_.group)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LoadPermission.ReadOnly =
    zio.aws.ec2.model.LoadPermission.wrap(buildAwsValue())
}
object LoadPermission {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LoadPermission
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LoadPermission = zio.aws.ec2.model
      .LoadPermission(userId.map(value => value), group.map(value => value))
    def userId: Optional[String]
    def group: Optional[zio.aws.ec2.model.PermissionGroup]
    def getUserId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userId", userId)
    def getGroup: ZIO[Any, AwsError, zio.aws.ec2.model.PermissionGroup] =
      AwsError.unwrapOptionField("group", group)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LoadPermission
  ) extends zio.aws.ec2.model.LoadPermission.ReadOnly {
    override val userId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => value: String)
    override val group: Optional[zio.aws.ec2.model.PermissionGroup] =
      zio.aws.core.internal
        .optionalFromNullable(impl.group())
        .map(value => zio.aws.ec2.model.PermissionGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LoadPermission
  ): zio.aws.ec2.model.LoadPermission.ReadOnly = new Wrapper(impl)
}
