package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, IpamScopeId, ResourceArn, IpamId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Ipam(
    ownerId: Optional[String] = Optional.Absent,
    ipamId: Optional[IpamId] = Optional.Absent,
    ipamArn: Optional[ResourceArn] = Optional.Absent,
    ipamRegion: Optional[String] = Optional.Absent,
    publicDefaultScopeId: Optional[IpamScopeId] = Optional.Absent,
    privateDefaultScopeId: Optional[IpamScopeId] = Optional.Absent,
    scopeCount: Optional[Integer] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    operatingRegions: Optional[
      Iterable[zio.aws.ec2.model.IpamOperatingRegion]
    ] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.IpamState] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Ipam = {
    import Ipam.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Ipam
      .builder()
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        ipamId.map(value => IpamId.unwrap(value): java.lang.String)
      )(_.ipamId)
      .optionallyWith(
        ipamArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.ipamArn)
      .optionallyWith(ipamRegion.map(value => value: java.lang.String))(
        _.ipamRegion
      )
      .optionallyWith(
        publicDefaultScopeId.map(value =>
          IpamScopeId.unwrap(value): java.lang.String
        )
      )(_.publicDefaultScopeId)
      .optionallyWith(
        privateDefaultScopeId.map(value =>
          IpamScopeId.unwrap(value): java.lang.String
        )
      )(_.privateDefaultScopeId)
      .optionallyWith(scopeCount.map(value => value: java.lang.Integer))(
        _.scopeCount
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        operatingRegions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operatingRegions)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Ipam.ReadOnly =
    zio.aws.ec2.model.Ipam.wrap(buildAwsValue())
}
object Ipam {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Ipam] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Ipam = zio.aws.ec2.model.Ipam(
      ownerId.map(value => value),
      ipamId.map(value => value),
      ipamArn.map(value => value),
      ipamRegion.map(value => value),
      publicDefaultScopeId.map(value => value),
      privateDefaultScopeId.map(value => value),
      scopeCount.map(value => value),
      description.map(value => value),
      operatingRegions.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      state.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def ownerId: Optional[String]
    def ipamId: Optional[IpamId]
    def ipamArn: Optional[ResourceArn]
    def ipamRegion: Optional[String]
    def publicDefaultScopeId: Optional[IpamScopeId]
    def privateDefaultScopeId: Optional[IpamScopeId]
    def scopeCount: Optional[Integer]
    def description: Optional[String]
    def operatingRegions
        : Optional[List[zio.aws.ec2.model.IpamOperatingRegion.ReadOnly]]
    def state: Optional[zio.aws.ec2.model.IpamState]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getIpamId: ZIO[Any, AwsError, IpamId] =
      AwsError.unwrapOptionField("ipamId", ipamId)
    def getIpamArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("ipamArn", ipamArn)
    def getIpamRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipamRegion", ipamRegion)
    def getPublicDefaultScopeId: ZIO[Any, AwsError, IpamScopeId] =
      AwsError.unwrapOptionField("publicDefaultScopeId", publicDefaultScopeId)
    def getPrivateDefaultScopeId: ZIO[Any, AwsError, IpamScopeId] =
      AwsError.unwrapOptionField("privateDefaultScopeId", privateDefaultScopeId)
    def getScopeCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("scopeCount", scopeCount)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getOperatingRegions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.IpamOperatingRegion.ReadOnly
    ]] = AwsError.unwrapOptionField("operatingRegions", operatingRegions)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.IpamState] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Ipam
  ) extends zio.aws.ec2.model.Ipam.ReadOnly {
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val ipamId: Optional[IpamId] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamId())
      .map(value => zio.aws.ec2.model.primitives.IpamId(value))
    override val ipamArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val ipamRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamRegion())
      .map(value => value: String)
    override val publicDefaultScopeId: Optional[IpamScopeId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicDefaultScopeId())
        .map(value => zio.aws.ec2.model.primitives.IpamScopeId(value))
    override val privateDefaultScopeId: Optional[IpamScopeId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateDefaultScopeId())
        .map(value => zio.aws.ec2.model.primitives.IpamScopeId(value))
    override val scopeCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.scopeCount())
      .map(value => value: Integer)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val operatingRegions
        : Optional[List[zio.aws.ec2.model.IpamOperatingRegion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingRegions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpamOperatingRegion.wrap(item)
          }.toList
        )
    override val state: Optional[zio.aws.ec2.model.IpamState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.IpamState.wrap(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Ipam
  ): zio.aws.ec2.model.Ipam.ReadOnly = new Wrapper(impl)
}
