package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceMaintenanceOptions(
    autoRecovery: Optional[zio.aws.ec2.model.InstanceAutoRecoveryState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceMaintenanceOptions = {
    import InstanceMaintenanceOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceMaintenanceOptions
      .builder()
      .optionallyWith(autoRecovery.map(value => value.unwrap))(_.autoRecovery)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceMaintenanceOptions.ReadOnly =
    zio.aws.ec2.model.InstanceMaintenanceOptions.wrap(buildAwsValue())
}
object InstanceMaintenanceOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceMaintenanceOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceMaintenanceOptions =
      zio.aws.ec2.model
        .InstanceMaintenanceOptions(autoRecovery.map(value => value))
    def autoRecovery: Optional[zio.aws.ec2.model.InstanceAutoRecoveryState]
    def getAutoRecovery
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceAutoRecoveryState] =
      AwsError.unwrapOptionField("autoRecovery", autoRecovery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceMaintenanceOptions
  ) extends zio.aws.ec2.model.InstanceMaintenanceOptions.ReadOnly {
    override val autoRecovery
        : Optional[zio.aws.ec2.model.InstanceAutoRecoveryState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoRecovery())
        .map(value => zio.aws.ec2.model.InstanceAutoRecoveryState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceMaintenanceOptions
  ): zio.aws.ec2.model.InstanceMaintenanceOptions.ReadOnly = new Wrapper(impl)
}
