package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceCreditSpecification(
    instanceId: Optional[String] = Optional.Absent,
    cpuCredits: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceCreditSpecification = {
    import InstanceCreditSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceCreditSpecification
      .builder()
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(cpuCredits.map(value => value: java.lang.String))(
        _.cpuCredits
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceCreditSpecification.ReadOnly =
    zio.aws.ec2.model.InstanceCreditSpecification.wrap(buildAwsValue())
}
object InstanceCreditSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceCreditSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceCreditSpecification =
      zio.aws.ec2.model.InstanceCreditSpecification(
        instanceId.map(value => value),
        cpuCredits.map(value => value)
      )
    def instanceId: Optional[String]
    def cpuCredits: Optional[String]
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getCpuCredits: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cpuCredits", cpuCredits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceCreditSpecification
  ) extends zio.aws.ec2.model.InstanceCreditSpecification.ReadOnly {
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
    override val cpuCredits: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cpuCredits())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceCreditSpecification
  ): zio.aws.ec2.model.InstanceCreditSpecification.ReadOnly = new Wrapper(impl)
}
