package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait HostRecovery {
  def unwrap: software.amazon.awssdk.services.ec2.model.HostRecovery
}
object HostRecovery {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.HostRecovery
  ): zio.aws.ec2.model.HostRecovery = value match {
    case software.amazon.awssdk.services.ec2.model.HostRecovery.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.HostRecovery.ON =>
      val r = on
      r
    case software.amazon.awssdk.services.ec2.model.HostRecovery.OFF =>
      val r = off
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.HostRecovery {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.HostRecovery =
      software.amazon.awssdk.services.ec2.model.HostRecovery.UNKNOWN_TO_SDK_VERSION
  }
  case object on extends zio.aws.ec2.model.HostRecovery {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.HostRecovery =
      software.amazon.awssdk.services.ec2.model.HostRecovery.ON
  }
  case object off extends zio.aws.ec2.model.HostRecovery {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.HostRecovery =
      software.amazon.awssdk.services.ec2.model.HostRecovery.OFF
  }
}
