package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTransitGatewayPolicyTableEntriesResponse(
    transitGatewayPolicyTableEntries: Optional[
      Iterable[zio.aws.ec2.model.TransitGatewayPolicyTableEntry]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableEntriesResponse = {
    import GetTransitGatewayPolicyTableEntriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableEntriesResponse
      .builder()
      .optionallyWith(
        transitGatewayPolicyTableEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayPolicyTableEntries)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetTransitGatewayPolicyTableEntriesResponse.ReadOnly =
    zio.aws.ec2.model.GetTransitGatewayPolicyTableEntriesResponse
      .wrap(buildAwsValue())
}
object GetTransitGatewayPolicyTableEntriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableEntriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetTransitGatewayPolicyTableEntriesResponse =
      zio.aws.ec2.model.GetTransitGatewayPolicyTableEntriesResponse(
        transitGatewayPolicyTableEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayPolicyTableEntries: Optional[
      List[zio.aws.ec2.model.TransitGatewayPolicyTableEntry.ReadOnly]
    ]
    def getTransitGatewayPolicyTableEntries: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayPolicyTableEntry.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayPolicyTableEntries",
      transitGatewayPolicyTableEntries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableEntriesResponse
  ) extends zio.aws.ec2.model.GetTransitGatewayPolicyTableEntriesResponse.ReadOnly {
    override val transitGatewayPolicyTableEntries: Optional[
      List[zio.aws.ec2.model.TransitGatewayPolicyTableEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayPolicyTableEntries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TransitGatewayPolicyTableEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableEntriesResponse
  ): zio.aws.ec2.model.GetTransitGatewayPolicyTableEntriesResponse.ReadOnly =
    new Wrapper(impl)
}
