package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FpgaImageAttribute(
    fpgaImageId: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    loadPermissions: Optional[Iterable[zio.aws.ec2.model.LoadPermission]] =
      Optional.Absent,
    productCodes: Optional[Iterable[zio.aws.ec2.model.ProductCode]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FpgaImageAttribute = {
    import FpgaImageAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FpgaImageAttribute
      .builder()
      .optionallyWith(fpgaImageId.map(value => value: java.lang.String))(
        _.fpgaImageId
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        loadPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadPermissions)
      .optionallyWith(
        productCodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productCodes)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FpgaImageAttribute.ReadOnly =
    zio.aws.ec2.model.FpgaImageAttribute.wrap(buildAwsValue())
}
object FpgaImageAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FpgaImageAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FpgaImageAttribute =
      zio.aws.ec2.model.FpgaImageAttribute(
        fpgaImageId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        loadPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        productCodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fpgaImageId: Optional[String]
    def name: Optional[String]
    def description: Optional[String]
    def loadPermissions
        : Optional[List[zio.aws.ec2.model.LoadPermission.ReadOnly]]
    def productCodes: Optional[List[zio.aws.ec2.model.ProductCode.ReadOnly]]
    def getFpgaImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fpgaImageId", fpgaImageId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getLoadPermissions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.LoadPermission.ReadOnly]] =
      AwsError.unwrapOptionField("loadPermissions", loadPermissions)
    def getProductCodes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      AwsError.unwrapOptionField("productCodes", productCodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FpgaImageAttribute
  ) extends zio.aws.ec2.model.FpgaImageAttribute.ReadOnly {
    override val fpgaImageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fpgaImageId())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val loadPermissions
        : Optional[List[zio.aws.ec2.model.LoadPermission.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadPermissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.LoadPermission.wrap(item)
          }.toList
        )
    override val productCodes
        : Optional[List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ProductCode.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FpgaImageAttribute
  ): zio.aws.ec2.model.FpgaImageAttribute.ReadOnly = new Wrapper(impl)
}
