package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeSpotPriceHistoryResponse(
    nextToken: Optional[String] = Optional.Absent,
    spotPriceHistory: Optional[Iterable[zio.aws.ec2.model.SpotPrice]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryResponse = {
    import DescribeSpotPriceHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        spotPriceHistory.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.spotPriceHistory)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSpotPriceHistoryResponse.ReadOnly =
    zio.aws.ec2.model.DescribeSpotPriceHistoryResponse.wrap(buildAwsValue())
}
object DescribeSpotPriceHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSpotPriceHistoryResponse =
      zio.aws.ec2.model.DescribeSpotPriceHistoryResponse(
        nextToken.map(value => value),
        spotPriceHistory.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def spotPriceHistory: Optional[List[zio.aws.ec2.model.SpotPrice.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSpotPriceHistory
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.SpotPrice.ReadOnly]] =
      AwsError.unwrapOptionField("spotPriceHistory", spotPriceHistory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryResponse
  ) extends zio.aws.ec2.model.DescribeSpotPriceHistoryResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val spotPriceHistory
        : Optional[List[zio.aws.ec2.model.SpotPrice.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spotPriceHistory())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.SpotPrice.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryResponse
  ): zio.aws.ec2.model.DescribeSpotPriceHistoryResponse.ReadOnly = new Wrapper(
    impl
  )
}
