package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  DescribeClientVpnTargetNetworksMaxResults,
  ClientVpnEndpointId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeClientVpnTargetNetworksRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    associationIds: Optional[Iterable[String]] = Optional.Absent,
    maxResults: Optional[DescribeClientVpnTargetNetworksMaxResults] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest = {
    import DescribeClientVpnTargetNetworksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .optionallyWith(
        associationIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.associationIds)
      .optionallyWith(
        maxResults.map(value =>
          DescribeClientVpnTargetNetworksMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeClientVpnTargetNetworksRequest.ReadOnly =
    zio.aws.ec2.model.DescribeClientVpnTargetNetworksRequest
      .wrap(buildAwsValue())
}
object DescribeClientVpnTargetNetworksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeClientVpnTargetNetworksRequest =
      zio.aws.ec2.model.DescribeClientVpnTargetNetworksRequest(
        clientVpnEndpointId,
        associationIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def associationIds: Optional[List[String]]
    def maxResults: Optional[DescribeClientVpnTargetNetworksMaxResults]
    def nextToken: Optional[NextToken]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getAssociationIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("associationIds", associationIds)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeClientVpnTargetNetworksMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest
  ) extends zio.aws.ec2.model.DescribeClientVpnTargetNetworksRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val associationIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.associationIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val maxResults
        : Optional[DescribeClientVpnTargetNetworksMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeClientVpnTargetNetworksMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest
  ): zio.aws.ec2.model.DescribeClientVpnTargetNetworksRequest.ReadOnly =
    new Wrapper(impl)
}
