package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeByoipCidrsResponse(
    byoipCidrs: Optional[Iterable[zio.aws.ec2.model.ByoipCidr]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse = {
    import DescribeByoipCidrsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse
      .builder()
      .optionallyWith(
        byoipCidrs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.byoipCidrs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeByoipCidrsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeByoipCidrsResponse.wrap(buildAwsValue())
}
object DescribeByoipCidrsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeByoipCidrsResponse =
      zio.aws.ec2.model.DescribeByoipCidrsResponse(
        byoipCidrs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def byoipCidrs: Optional[List[zio.aws.ec2.model.ByoipCidr.ReadOnly]]
    def nextToken: Optional[String]
    def getByoipCidrs
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ByoipCidr.ReadOnly]] =
      AwsError.unwrapOptionField("byoipCidrs", byoipCidrs)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse
  ) extends zio.aws.ec2.model.DescribeByoipCidrsResponse.ReadOnly {
    override val byoipCidrs
        : Optional[List[zio.aws.ec2.model.ByoipCidr.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.byoipCidrs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ByoipCidr.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse
  ): zio.aws.ec2.model.DescribeByoipCidrsResponse.ReadOnly = new Wrapper(impl)
}
