package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeregisterInstanceEventNotificationAttributesResponse(
    instanceTagAttribute: Optional[
      zio.aws.ec2.model.InstanceTagNotificationAttribute
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesResponse = {
    import DeregisterInstanceEventNotificationAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesResponse
      .builder()
      .optionallyWith(instanceTagAttribute.map(value => value.buildAwsValue()))(
        _.instanceTagAttribute
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesResponse.ReadOnly =
    zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesResponse
      .wrap(buildAwsValue())
}
object DeregisterInstanceEventNotificationAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesResponse =
      zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesResponse(
        instanceTagAttribute.map(value => value.asEditable)
      )
    def instanceTagAttribute
        : Optional[zio.aws.ec2.model.InstanceTagNotificationAttribute.ReadOnly]
    def getInstanceTagAttribute: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceTagNotificationAttribute.ReadOnly
    ] = AwsError.unwrapOptionField("instanceTagAttribute", instanceTagAttribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesResponse
  ) extends zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesResponse.ReadOnly {
    override val instanceTagAttribute: Optional[
      zio.aws.ec2.model.InstanceTagNotificationAttribute.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceTagAttribute())
      .map(value =>
        zio.aws.ec2.model.InstanceTagNotificationAttribute.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesResponse
  ): zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
