package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ReservationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteQueuedReservedInstancesRequest(
    reservedInstancesIds: Iterable[ReservationId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesRequest = {
    import DeleteQueuedReservedInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesRequest
      .builder()
      .reservedInstancesIds(reservedInstancesIds.map { item =>
        ReservationId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteQueuedReservedInstancesRequest.ReadOnly =
    zio.aws.ec2.model.DeleteQueuedReservedInstancesRequest.wrap(buildAwsValue())
}
object DeleteQueuedReservedInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteQueuedReservedInstancesRequest =
      zio.aws.ec2.model
        .DeleteQueuedReservedInstancesRequest(reservedInstancesIds)
    def reservedInstancesIds: List[ReservationId]
    def getReservedInstancesIds: ZIO[Any, Nothing, List[ReservationId]] =
      ZIO.succeed(reservedInstancesIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesRequest
  ) extends zio.aws.ec2.model.DeleteQueuedReservedInstancesRequest.ReadOnly {
    override val reservedInstancesIds: List[ReservationId] = impl
      .reservedInstancesIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.ReservationId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesRequest
  ): zio.aws.ec2.model.DeleteQueuedReservedInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
