package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInterfaceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteNetworkInterfaceRequest(
    networkInterfaceId: NetworkInterfaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfaceRequest = {
    import DeleteNetworkInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfaceRequest
      .builder()
      .networkInterfaceId(
        NetworkInterfaceId.unwrap(networkInterfaceId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteNetworkInterfaceRequest.ReadOnly =
    zio.aws.ec2.model.DeleteNetworkInterfaceRequest.wrap(buildAwsValue())
}
object DeleteNetworkInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteNetworkInterfaceRequest =
      zio.aws.ec2.model.DeleteNetworkInterfaceRequest(networkInterfaceId)
    def networkInterfaceId: NetworkInterfaceId
    def getNetworkInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(networkInterfaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfaceRequest
  ) extends zio.aws.ec2.model.DeleteNetworkInterfaceRequest.ReadOnly {
    override val networkInterfaceId: NetworkInterfaceId =
      zio.aws.ec2.model.primitives.NetworkInterfaceId(impl.networkInterfaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfaceRequest
  ): zio.aws.ec2.model.DeleteNetworkInterfaceRequest.ReadOnly = new Wrapper(
    impl
  )
}
