package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitGatewayAttachmentId,
  TransitGatewayRouteTableId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayRouteTableAnnouncementRequest(
    transitGatewayRouteTableId: TransitGatewayRouteTableId,
    peeringAttachmentId: TransitGatewayAttachmentId,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableAnnouncementRequest = {
    import CreateTransitGatewayRouteTableAnnouncementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableAnnouncementRequest
      .builder()
      .transitGatewayRouteTableId(
        TransitGatewayRouteTableId.unwrap(
          transitGatewayRouteTableId
        ): java.lang.String
      )
      .peeringAttachmentId(
        TransitGatewayAttachmentId.unwrap(peeringAttachmentId): java.lang.String
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateTransitGatewayRouteTableAnnouncementRequest.ReadOnly =
    zio.aws.ec2.model.CreateTransitGatewayRouteTableAnnouncementRequest
      .wrap(buildAwsValue())
}
object CreateTransitGatewayRouteTableAnnouncementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableAnnouncementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateTransitGatewayRouteTableAnnouncementRequest =
      zio.aws.ec2.model.CreateTransitGatewayRouteTableAnnouncementRequest(
        transitGatewayRouteTableId,
        peeringAttachmentId,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayRouteTableId: TransitGatewayRouteTableId
    def peeringAttachmentId: TransitGatewayAttachmentId
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getTransitGatewayRouteTableId
        : ZIO[Any, Nothing, TransitGatewayRouteTableId] =
      ZIO.succeed(transitGatewayRouteTableId)
    def getPeeringAttachmentId: ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(peeringAttachmentId)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableAnnouncementRequest
  ) extends zio.aws.ec2.model.CreateTransitGatewayRouteTableAnnouncementRequest.ReadOnly {
    override val transitGatewayRouteTableId: TransitGatewayRouteTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayRouteTableId(impl.transitGatewayRouteTableId())
    override val peeringAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.peeringAttachmentId())
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableAnnouncementRequest
  ): zio.aws.ec2.model.CreateTransitGatewayRouteTableAnnouncementRequest.ReadOnly =
    new Wrapper(impl)
}
