package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayMulticastDomainResponse(
    transitGatewayMulticastDomain: Optional[
      zio.aws.ec2.model.TransitGatewayMulticastDomain
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainResponse = {
    import CreateTransitGatewayMulticastDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainResponse
      .builder()
      .optionallyWith(
        transitGatewayMulticastDomain.map(value => value.buildAwsValue())
      )(_.transitGatewayMulticastDomain)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateTransitGatewayMulticastDomainResponse.ReadOnly =
    zio.aws.ec2.model.CreateTransitGatewayMulticastDomainResponse
      .wrap(buildAwsValue())
}
object CreateTransitGatewayMulticastDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateTransitGatewayMulticastDomainResponse =
      zio.aws.ec2.model.CreateTransitGatewayMulticastDomainResponse(
        transitGatewayMulticastDomain.map(value => value.asEditable)
      )
    def transitGatewayMulticastDomain
        : Optional[zio.aws.ec2.model.TransitGatewayMulticastDomain.ReadOnly]
    def getTransitGatewayMulticastDomain: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayMulticastDomain.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayMulticastDomain",
      transitGatewayMulticastDomain
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainResponse
  ) extends zio.aws.ec2.model.CreateTransitGatewayMulticastDomainResponse.ReadOnly {
    override val transitGatewayMulticastDomain
        : Optional[zio.aws.ec2.model.TransitGatewayMulticastDomain.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayMulticastDomain())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayMulticastDomain.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainResponse
  ): zio.aws.ec2.model.CreateTransitGatewayMulticastDomainResponse.ReadOnly =
    new Wrapper(impl)
}
