package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDhcpOptionsRequest(
    dhcpConfigurations: Iterable[zio.aws.ec2.model.NewDhcpConfiguration],
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsRequest = {
    import CreateDhcpOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsRequest
      .builder()
      .dhcpConfigurations(dhcpConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateDhcpOptionsRequest.ReadOnly =
    zio.aws.ec2.model.CreateDhcpOptionsRequest.wrap(buildAwsValue())
}
object CreateDhcpOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateDhcpOptionsRequest =
      zio.aws.ec2.model.CreateDhcpOptionsRequest(
        dhcpConfigurations.map { item =>
          item.asEditable
        },
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dhcpConfigurations
        : List[zio.aws.ec2.model.NewDhcpConfiguration.ReadOnly]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getDhcpConfigurations: ZIO[Any, Nothing, List[
      zio.aws.ec2.model.NewDhcpConfiguration.ReadOnly
    ]] = ZIO.succeed(dhcpConfigurations)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsRequest
  ) extends zio.aws.ec2.model.CreateDhcpOptionsRequest.ReadOnly {
    override val dhcpConfigurations
        : List[zio.aws.ec2.model.NewDhcpConfiguration.ReadOnly] = impl
      .dhcpConfigurations()
      .asScala
      .map { item =>
        zio.aws.ec2.model.NewDhcpConfiguration.wrap(item)
      }
      .toList
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsRequest
  ): zio.aws.ec2.model.CreateDhcpOptionsRequest.ReadOnly = new Wrapper(impl)
}
