package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait CancelSpotInstanceRequestState {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState
}
object CancelSpotInstanceRequestState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState
  ): zio.aws.ec2.model.CancelSpotInstanceRequestState = value match {
    case software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState.OPEN =>
      val r = open
      r
    case software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState.CLOSED =>
      val r = closed
      r
    case software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState.CANCELLED =>
      val r = cancelled
      r
    case software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState.COMPLETED =>
      val r = completed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.CancelSpotInstanceRequestState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState =
      software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState.UNKNOWN_TO_SDK_VERSION
  }
  case object active extends zio.aws.ec2.model.CancelSpotInstanceRequestState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState =
      software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState.ACTIVE
  }
  case object open extends zio.aws.ec2.model.CancelSpotInstanceRequestState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState =
      software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState.OPEN
  }
  case object closed extends zio.aws.ec2.model.CancelSpotInstanceRequestState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState =
      software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState.CLOSED
  }
  case object cancelled
      extends zio.aws.ec2.model.CancelSpotInstanceRequestState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState =
      software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState.CANCELLED
  }
  case object completed
      extends zio.aws.ec2.model.CancelSpotInstanceRequestState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState =
      software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState.COMPLETED
  }
}
