package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpnGatewayId, VpcId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AttachVpnGatewayRequest(
    vpcId: VpcId,
    vpnGatewayId: VpnGatewayId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AttachVpnGatewayRequest = {
    import AttachVpnGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AttachVpnGatewayRequest
      .builder()
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .vpnGatewayId(VpnGatewayId.unwrap(vpnGatewayId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AttachVpnGatewayRequest.ReadOnly =
    zio.aws.ec2.model.AttachVpnGatewayRequest.wrap(buildAwsValue())
}
object AttachVpnGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AttachVpnGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AttachVpnGatewayRequest =
      zio.aws.ec2.model.AttachVpnGatewayRequest(vpcId, vpnGatewayId)
    def vpcId: VpcId
    def vpnGatewayId: VpnGatewayId
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getVpnGatewayId: ZIO[Any, Nothing, VpnGatewayId] =
      ZIO.succeed(vpnGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AttachVpnGatewayRequest
  ) extends zio.aws.ec2.model.AttachVpnGatewayRequest.ReadOnly {
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
    override val vpnGatewayId: VpnGatewayId =
      zio.aws.ec2.model.primitives.VpnGatewayId(impl.vpnGatewayId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AttachVpnGatewayRequest
  ): zio.aws.ec2.model.AttachVpnGatewayRequest.ReadOnly = new Wrapper(impl)
}
