package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddedPrincipal(
    principalType: Optional[zio.aws.ec2.model.PrincipalType] = Optional.Absent,
    principal: Optional[String] = Optional.Absent,
    servicePermissionId: Optional[String] = Optional.Absent,
    serviceId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AddedPrincipal = {
    import AddedPrincipal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AddedPrincipal
      .builder()
      .optionallyWith(principalType.map(value => value.unwrap))(_.principalType)
      .optionallyWith(principal.map(value => value: java.lang.String))(
        _.principal
      )
      .optionallyWith(
        servicePermissionId.map(value => value: java.lang.String)
      )(_.servicePermissionId)
      .optionallyWith(serviceId.map(value => value: java.lang.String))(
        _.serviceId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AddedPrincipal.ReadOnly =
    zio.aws.ec2.model.AddedPrincipal.wrap(buildAwsValue())
}
object AddedPrincipal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AddedPrincipal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AddedPrincipal =
      zio.aws.ec2.model.AddedPrincipal(
        principalType.map(value => value),
        principal.map(value => value),
        servicePermissionId.map(value => value),
        serviceId.map(value => value)
      )
    def principalType: Optional[zio.aws.ec2.model.PrincipalType]
    def principal: Optional[String]
    def servicePermissionId: Optional[String]
    def serviceId: Optional[String]
    def getPrincipalType: ZIO[Any, AwsError, zio.aws.ec2.model.PrincipalType] =
      AwsError.unwrapOptionField("principalType", principalType)
    def getPrincipal: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principal", principal)
    def getServicePermissionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("servicePermissionId", servicePermissionId)
    def getServiceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceId", serviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AddedPrincipal
  ) extends zio.aws.ec2.model.AddedPrincipal.ReadOnly {
    override val principalType: Optional[zio.aws.ec2.model.PrincipalType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principalType())
        .map(value => zio.aws.ec2.model.PrincipalType.wrap(value))
    override val principal: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.principal())
      .map(value => value: String)
    override val servicePermissionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.servicePermissionId())
      .map(value => value: String)
    override val serviceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AddedPrincipal
  ): zio.aws.ec2.model.AddedPrincipal.ReadOnly = new Wrapper(impl)
}
