package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VirtualizationType {
  def unwrap: software.amazon.awssdk.services.ec2.model.VirtualizationType
}
object VirtualizationType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VirtualizationType
  ): zio.aws.ec2.model.VirtualizationType = value match {
    case software.amazon.awssdk.services.ec2.model.VirtualizationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VirtualizationType.HVM =>
      val r = hvm
      r
    case software.amazon.awssdk.services.ec2.model.VirtualizationType.PARAVIRTUAL =>
      val r = paravirtual
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.VirtualizationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VirtualizationType =
      software.amazon.awssdk.services.ec2.model.VirtualizationType.UNKNOWN_TO_SDK_VERSION
  }
  case object hvm extends zio.aws.ec2.model.VirtualizationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VirtualizationType =
      software.amazon.awssdk.services.ec2.model.VirtualizationType.HVM
  }
  case object paravirtual extends zio.aws.ec2.model.VirtualizationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VirtualizationType =
      software.amazon.awssdk.services.ec2.model.VirtualizationType.PARAVIRTUAL
  }
}
