package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SubnetCidrAssociationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SubnetIpv6CidrBlockAssociation(
    associationId: Optional[SubnetCidrAssociationId] = Optional.Absent,
    ipv6CidrBlock: Optional[String] = Optional.Absent,
    ipv6CidrBlockState: Optional[zio.aws.ec2.model.SubnetCidrBlockState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SubnetIpv6CidrBlockAssociation = {
    import SubnetIpv6CidrBlockAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SubnetIpv6CidrBlockAssociation
      .builder()
      .optionallyWith(
        associationId.map(value =>
          SubnetCidrAssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(ipv6CidrBlock.map(value => value: java.lang.String))(
        _.ipv6CidrBlock
      )
      .optionallyWith(ipv6CidrBlockState.map(value => value.buildAwsValue()))(
        _.ipv6CidrBlockState
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation.ReadOnly =
    zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation.wrap(buildAwsValue())
}
object SubnetIpv6CidrBlockAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SubnetIpv6CidrBlockAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation =
      zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation(
        associationId.map(value => value),
        ipv6CidrBlock.map(value => value),
        ipv6CidrBlockState.map(value => value.asEditable)
      )
    def associationId: Optional[SubnetCidrAssociationId]
    def ipv6CidrBlock: Optional[String]
    def ipv6CidrBlockState
        : Optional[zio.aws.ec2.model.SubnetCidrBlockState.ReadOnly]
    def getAssociationId: ZIO[Any, AwsError, SubnetCidrAssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getIpv6CidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6CidrBlock", ipv6CidrBlock)
    def getIpv6CidrBlockState
        : ZIO[Any, AwsError, zio.aws.ec2.model.SubnetCidrBlockState.ReadOnly] =
      AwsError.unwrapOptionField("ipv6CidrBlockState", ipv6CidrBlockState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SubnetIpv6CidrBlockAssociation
  ) extends zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation.ReadOnly {
    override val associationId: Optional[SubnetCidrAssociationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationId())
        .map(value =>
          zio.aws.ec2.model.primitives.SubnetCidrAssociationId(value)
        )
    override val ipv6CidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6CidrBlock())
      .map(value => value: String)
    override val ipv6CidrBlockState
        : Optional[zio.aws.ec2.model.SubnetCidrBlockState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv6CidrBlockState())
        .map(value => zio.aws.ec2.model.SubnetCidrBlockState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SubnetIpv6CidrBlockAssociation
  ): zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation.ReadOnly = new Wrapper(
    impl
  )
}
