package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResponseLaunchTemplateData(
    kernelId: Optional[String] = Optional.Absent,
    ebsOptimized: Optional[Boolean] = Optional.Absent,
    iamInstanceProfile: Optional[
      zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecification
    ] = Optional.Absent,
    blockDeviceMappings: Optional[
      Iterable[zio.aws.ec2.model.LaunchTemplateBlockDeviceMapping]
    ] = Optional.Absent,
    networkInterfaces: Optional[Iterable[
      zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification
    ]] = Optional.Absent,
    imageId: Optional[String] = Optional.Absent,
    instanceType: Optional[zio.aws.ec2.model.InstanceType] = Optional.Absent,
    keyName: Optional[String] = Optional.Absent,
    monitoring: Optional[zio.aws.ec2.model.LaunchTemplatesMonitoring] =
      Optional.Absent,
    placement: Optional[zio.aws.ec2.model.LaunchTemplatePlacement] =
      Optional.Absent,
    ramDiskId: Optional[String] = Optional.Absent,
    disableApiTermination: Optional[Boolean] = Optional.Absent,
    instanceInitiatedShutdownBehavior: Optional[
      zio.aws.ec2.model.ShutdownBehavior
    ] = Optional.Absent,
    userData: Optional[String] = Optional.Absent,
    tagSpecifications: Optional[
      Iterable[zio.aws.ec2.model.LaunchTemplateTagSpecification]
    ] = Optional.Absent,
    elasticGpuSpecifications: Optional[
      Iterable[zio.aws.ec2.model.ElasticGpuSpecificationResponse]
    ] = Optional.Absent,
    elasticInferenceAccelerators: Optional[Iterable[
      zio.aws.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse
    ]] = Optional.Absent,
    securityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    securityGroups: Optional[Iterable[String]] = Optional.Absent,
    instanceMarketOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateInstanceMarketOptions
    ] = Optional.Absent,
    creditSpecification: Optional[zio.aws.ec2.model.CreditSpecification] =
      Optional.Absent,
    cpuOptions: Optional[zio.aws.ec2.model.LaunchTemplateCpuOptions] =
      Optional.Absent,
    capacityReservationSpecification: Optional[
      zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse
    ] = Optional.Absent,
    licenseSpecifications: Optional[
      Iterable[zio.aws.ec2.model.LaunchTemplateLicenseConfiguration]
    ] = Optional.Absent,
    hibernationOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateHibernationOptions
    ] = Optional.Absent,
    metadataOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptions
    ] = Optional.Absent,
    enclaveOptions: Optional[zio.aws.ec2.model.LaunchTemplateEnclaveOptions] =
      Optional.Absent,
    instanceRequirements: Optional[zio.aws.ec2.model.InstanceRequirements] =
      Optional.Absent,
    privateDnsNameOptions: Optional[
      zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptions
    ] = Optional.Absent,
    maintenanceOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptions
    ] = Optional.Absent,
    disableApiStop: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ResponseLaunchTemplateData = {
    import ResponseLaunchTemplateData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ResponseLaunchTemplateData
      .builder()
      .optionallyWith(kernelId.map(value => value: java.lang.String))(
        _.kernelId
      )
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(keyName.map(value => value: java.lang.String))(_.keyName)
      .optionallyWith(monitoring.map(value => value.buildAwsValue()))(
        _.monitoring
      )
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(ramDiskId.map(value => value: java.lang.String))(
        _.ramDiskId
      )
      .optionallyWith(
        disableApiTermination.map(value => value: java.lang.Boolean)
      )(_.disableApiTermination)
      .optionallyWith(
        instanceInitiatedShutdownBehavior.map(value => value.unwrap)
      )(_.instanceInitiatedShutdownBehavior)
      .optionallyWith(userData.map(value => value: java.lang.String))(
        _.userData
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(
        elasticGpuSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticGpuSpecifications)
      .optionallyWith(
        elasticInferenceAccelerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticInferenceAccelerators)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        instanceMarketOptions.map(value => value.buildAwsValue())
      )(_.instanceMarketOptions)
      .optionallyWith(creditSpecification.map(value => value.buildAwsValue()))(
        _.creditSpecification
      )
      .optionallyWith(cpuOptions.map(value => value.buildAwsValue()))(
        _.cpuOptions
      )
      .optionallyWith(
        capacityReservationSpecification.map(value => value.buildAwsValue())
      )(_.capacityReservationSpecification)
      .optionallyWith(
        licenseSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseSpecifications)
      .optionallyWith(hibernationOptions.map(value => value.buildAwsValue()))(
        _.hibernationOptions
      )
      .optionallyWith(metadataOptions.map(value => value.buildAwsValue()))(
        _.metadataOptions
      )
      .optionallyWith(enclaveOptions.map(value => value.buildAwsValue()))(
        _.enclaveOptions
      )
      .optionallyWith(instanceRequirements.map(value => value.buildAwsValue()))(
        _.instanceRequirements
      )
      .optionallyWith(
        privateDnsNameOptions.map(value => value.buildAwsValue())
      )(_.privateDnsNameOptions)
      .optionallyWith(maintenanceOptions.map(value => value.buildAwsValue()))(
        _.maintenanceOptions
      )
      .optionallyWith(disableApiStop.map(value => value: java.lang.Boolean))(
        _.disableApiStop
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ResponseLaunchTemplateData.ReadOnly =
    zio.aws.ec2.model.ResponseLaunchTemplateData.wrap(buildAwsValue())
}
object ResponseLaunchTemplateData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ResponseLaunchTemplateData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ResponseLaunchTemplateData =
      zio.aws.ec2.model.ResponseLaunchTemplateData(
        kernelId.map(value => value),
        ebsOptimized.map(value => value),
        iamInstanceProfile.map(value => value.asEditable),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageId.map(value => value),
        instanceType.map(value => value),
        keyName.map(value => value),
        monitoring.map(value => value.asEditable),
        placement.map(value => value.asEditable),
        ramDiskId.map(value => value),
        disableApiTermination.map(value => value),
        instanceInitiatedShutdownBehavior.map(value => value),
        userData.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        elasticGpuSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        elasticInferenceAccelerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityGroupIds.map(value => value),
        securityGroups.map(value => value),
        instanceMarketOptions.map(value => value.asEditable),
        creditSpecification.map(value => value.asEditable),
        cpuOptions.map(value => value.asEditable),
        capacityReservationSpecification.map(value => value.asEditable),
        licenseSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hibernationOptions.map(value => value.asEditable),
        metadataOptions.map(value => value.asEditable),
        enclaveOptions.map(value => value.asEditable),
        instanceRequirements.map(value => value.asEditable),
        privateDnsNameOptions.map(value => value.asEditable),
        maintenanceOptions.map(value => value.asEditable),
        disableApiStop.map(value => value)
      )
    def kernelId: Optional[String]
    def ebsOptimized: Optional[Boolean]
    def iamInstanceProfile: Optional[
      zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecification.ReadOnly
    ]
    def blockDeviceMappings: Optional[
      List[zio.aws.ec2.model.LaunchTemplateBlockDeviceMapping.ReadOnly]
    ]
    def networkInterfaces: Optional[List[
      zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification.ReadOnly
    ]]
    def imageId: Optional[String]
    def instanceType: Optional[zio.aws.ec2.model.InstanceType]
    def keyName: Optional[String]
    def monitoring
        : Optional[zio.aws.ec2.model.LaunchTemplatesMonitoring.ReadOnly]
    def placement: Optional[zio.aws.ec2.model.LaunchTemplatePlacement.ReadOnly]
    def ramDiskId: Optional[String]
    def disableApiTermination: Optional[Boolean]
    def instanceInitiatedShutdownBehavior
        : Optional[zio.aws.ec2.model.ShutdownBehavior]
    def userData: Optional[String]
    def tagSpecifications: Optional[
      List[zio.aws.ec2.model.LaunchTemplateTagSpecification.ReadOnly]
    ]
    def elasticGpuSpecifications: Optional[
      List[zio.aws.ec2.model.ElasticGpuSpecificationResponse.ReadOnly]
    ]
    def elasticInferenceAccelerators: Optional[List[
      zio.aws.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse.ReadOnly
    ]]
    def securityGroupIds: Optional[List[String]]
    def securityGroups: Optional[List[String]]
    def instanceMarketOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateInstanceMarketOptions.ReadOnly
    ]
    def creditSpecification
        : Optional[zio.aws.ec2.model.CreditSpecification.ReadOnly]
    def cpuOptions
        : Optional[zio.aws.ec2.model.LaunchTemplateCpuOptions.ReadOnly]
    def capacityReservationSpecification: Optional[
      zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse.ReadOnly
    ]
    def licenseSpecifications: Optional[
      List[zio.aws.ec2.model.LaunchTemplateLicenseConfiguration.ReadOnly]
    ]
    def hibernationOptions
        : Optional[zio.aws.ec2.model.LaunchTemplateHibernationOptions.ReadOnly]
    def metadataOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptions.ReadOnly
    ]
    def enclaveOptions
        : Optional[zio.aws.ec2.model.LaunchTemplateEnclaveOptions.ReadOnly]
    def instanceRequirements
        : Optional[zio.aws.ec2.model.InstanceRequirements.ReadOnly]
    def privateDnsNameOptions: Optional[
      zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptions.ReadOnly
    ]
    def maintenanceOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptions.ReadOnly
    ]
    def disableApiStop: Optional[Boolean]
    def getKernelId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getIamInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateBlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKeyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getMonitoring: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplatesMonitoring.ReadOnly
    ] = AwsError.unwrapOptionField("monitoring", monitoring)
    def getPlacement: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplatePlacement.ReadOnly
    ] = AwsError.unwrapOptionField("placement", placement)
    def getRamDiskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ramDiskId", ramDiskId)
    def getDisableApiTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disableApiTermination", disableApiTermination)
    def getInstanceInitiatedShutdownBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.ShutdownBehavior] =
      AwsError.unwrapOptionField(
        "instanceInitiatedShutdownBehavior",
        instanceInitiatedShutdownBehavior
      )
    def getUserData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userData", userData)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateTagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getElasticGpuSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ElasticGpuSpecificationResponse.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "elasticGpuSpecifications",
      elasticGpuSpecifications
    )
    def getElasticInferenceAccelerators: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "elasticInferenceAccelerators",
      elasticInferenceAccelerators
    )
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getInstanceMarketOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateInstanceMarketOptions.ReadOnly
    ] =
      AwsError.unwrapOptionField("instanceMarketOptions", instanceMarketOptions)
    def getCreditSpecification
        : ZIO[Any, AwsError, zio.aws.ec2.model.CreditSpecification.ReadOnly] =
      AwsError.unwrapOptionField("creditSpecification", creditSpecification)
    def getCpuOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateCpuOptions.ReadOnly
    ] = AwsError.unwrapOptionField("cpuOptions", cpuOptions)
    def getCapacityReservationSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "capacityReservationSpecification",
      capacityReservationSpecification
    )
    def getLicenseSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateLicenseConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("licenseSpecifications", licenseSpecifications)
    def getHibernationOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateHibernationOptions.ReadOnly
    ] = AwsError.unwrapOptionField("hibernationOptions", hibernationOptions)
    def getMetadataOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptions.ReadOnly
    ] = AwsError.unwrapOptionField("metadataOptions", metadataOptions)
    def getEnclaveOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateEnclaveOptions.ReadOnly
    ] = AwsError.unwrapOptionField("enclaveOptions", enclaveOptions)
    def getInstanceRequirements
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceRequirements.ReadOnly] =
      AwsError.unwrapOptionField("instanceRequirements", instanceRequirements)
    def getPrivateDnsNameOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptions.ReadOnly
    ] =
      AwsError.unwrapOptionField("privateDnsNameOptions", privateDnsNameOptions)
    def getMaintenanceOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptions.ReadOnly
    ] = AwsError.unwrapOptionField("maintenanceOptions", maintenanceOptions)
    def getDisableApiStop: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disableApiStop", disableApiStop)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ResponseLaunchTemplateData
  ) extends zio.aws.ec2.model.ResponseLaunchTemplateData.ReadOnly {
    override val kernelId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kernelId())
      .map(value => value: String)
    override val ebsOptimized: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsOptimized())
      .map(value => value: Boolean)
    override val iamInstanceProfile: Optional[
      zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.iamInstanceProfile())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecification
          .wrap(value)
      )
    override val blockDeviceMappings: Optional[
      List[zio.aws.ec2.model.LaunchTemplateBlockDeviceMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateBlockDeviceMapping.wrap(item)
        }.toList
      )
    override val networkInterfaces: Optional[List[
      zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification
            .wrap(item)
        }.toList
      )
    override val imageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => value: String)
    override val instanceType: Optional[zio.aws.ec2.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val keyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keyName())
      .map(value => value: String)
    override val monitoring
        : Optional[zio.aws.ec2.model.LaunchTemplatesMonitoring.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoring())
        .map(value => zio.aws.ec2.model.LaunchTemplatesMonitoring.wrap(value))
    override val placement
        : Optional[zio.aws.ec2.model.LaunchTemplatePlacement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placement())
        .map(value => zio.aws.ec2.model.LaunchTemplatePlacement.wrap(value))
    override val ramDiskId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ramDiskId())
      .map(value => value: String)
    override val disableApiTermination: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableApiTermination())
        .map(value => value: Boolean)
    override val instanceInitiatedShutdownBehavior
        : Optional[zio.aws.ec2.model.ShutdownBehavior] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceInitiatedShutdownBehavior())
      .map(value => zio.aws.ec2.model.ShutdownBehavior.wrap(value))
    override val userData: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userData())
      .map(value => value: String)
    override val tagSpecifications: Optional[
      List[zio.aws.ec2.model.LaunchTemplateTagSpecification.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateTagSpecification.wrap(item)
        }.toList
      )
    override val elasticGpuSpecifications: Optional[
      List[zio.aws.ec2.model.ElasticGpuSpecificationResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticGpuSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ElasticGpuSpecificationResponse.wrap(item)
        }.toList
      )
    override val elasticInferenceAccelerators: Optional[List[
      zio.aws.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticInferenceAccelerators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse
            .wrap(item)
        }.toList
      )
    override val securityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val securityGroups: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val instanceMarketOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateInstanceMarketOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceMarketOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateInstanceMarketOptions.wrap(value)
      )
    override val creditSpecification
        : Optional[zio.aws.ec2.model.CreditSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creditSpecification())
        .map(value => zio.aws.ec2.model.CreditSpecification.wrap(value))
    override val cpuOptions
        : Optional[zio.aws.ec2.model.LaunchTemplateCpuOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cpuOptions())
        .map(value => zio.aws.ec2.model.LaunchTemplateCpuOptions.wrap(value))
    override val capacityReservationSpecification: Optional[
      zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityReservationSpecification())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse
          .wrap(value)
      )
    override val licenseSpecifications: Optional[
      List[zio.aws.ec2.model.LaunchTemplateLicenseConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateLicenseConfiguration.wrap(item)
        }.toList
      )
    override val hibernationOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateHibernationOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hibernationOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateHibernationOptions.wrap(value)
      )
    override val metadataOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metadataOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptions.wrap(value)
      )
    override val enclaveOptions
        : Optional[zio.aws.ec2.model.LaunchTemplateEnclaveOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enclaveOptions())
        .map(value =>
          zio.aws.ec2.model.LaunchTemplateEnclaveOptions.wrap(value)
        )
    override val instanceRequirements
        : Optional[zio.aws.ec2.model.InstanceRequirements.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceRequirements())
        .map(value => zio.aws.ec2.model.InstanceRequirements.wrap(value))
    override val privateDnsNameOptions: Optional[
      zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsNameOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptions.wrap(value)
      )
    override val maintenanceOptions: Optional[
      zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptions.wrap(value)
      )
    override val disableApiStop: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disableApiStop())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ResponseLaunchTemplateData
  ): zio.aws.ec2.model.ResponseLaunchTemplateData.ReadOnly = new Wrapper(impl)
}
