package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ReservedInstanceState {
  def unwrap: software.amazon.awssdk.services.ec2.model.ReservedInstanceState
}
object ReservedInstanceState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ReservedInstanceState
  ): zio.aws.ec2.model.ReservedInstanceState = value match {
    case software.amazon.awssdk.services.ec2.model.ReservedInstanceState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ReservedInstanceState.PAYMENT_PENDING =>
      val r = `payment-pending`
      r
    case software.amazon.awssdk.services.ec2.model.ReservedInstanceState.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.ec2.model.ReservedInstanceState.PAYMENT_FAILED =>
      val r = `payment-failed`
      r
    case software.amazon.awssdk.services.ec2.model.ReservedInstanceState.RETIRED =>
      val r = retired
      r
    case software.amazon.awssdk.services.ec2.model.ReservedInstanceState.QUEUED =>
      val r = queued
      r
    case software.amazon.awssdk.services.ec2.model.ReservedInstanceState.QUEUED_DELETED =>
      val r = `queued-deleted`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.ReservedInstanceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReservedInstanceState =
      software.amazon.awssdk.services.ec2.model.ReservedInstanceState.UNKNOWN_TO_SDK_VERSION
  }
  case object `payment-pending`
      extends zio.aws.ec2.model.ReservedInstanceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReservedInstanceState =
      software.amazon.awssdk.services.ec2.model.ReservedInstanceState.PAYMENT_PENDING
  }
  case object active extends zio.aws.ec2.model.ReservedInstanceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReservedInstanceState =
      software.amazon.awssdk.services.ec2.model.ReservedInstanceState.ACTIVE
  }
  case object `payment-failed` extends zio.aws.ec2.model.ReservedInstanceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReservedInstanceState =
      software.amazon.awssdk.services.ec2.model.ReservedInstanceState.PAYMENT_FAILED
  }
  case object retired extends zio.aws.ec2.model.ReservedInstanceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReservedInstanceState =
      software.amazon.awssdk.services.ec2.model.ReservedInstanceState.RETIRED
  }
  case object queued extends zio.aws.ec2.model.ReservedInstanceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReservedInstanceState =
      software.amazon.awssdk.services.ec2.model.ReservedInstanceState.QUEUED
  }
  case object `queued-deleted` extends zio.aws.ec2.model.ReservedInstanceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReservedInstanceState =
      software.amazon.awssdk.services.ec2.model.ReservedInstanceState.QUEUED_DELETED
  }
}
