package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait LocalGatewayRouteState {
  def unwrap: software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState
}
object LocalGatewayRouteState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState
  ): zio.aws.ec2.model.LocalGatewayRouteState = value match {
    case software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState.BLACKHOLE =>
      val r = blackhole
      r
    case software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState.DELETED =>
      val r = deleted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.LocalGatewayRouteState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState =
      software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.LocalGatewayRouteState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState =
      software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState.PENDING
  }
  case object active extends zio.aws.ec2.model.LocalGatewayRouteState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState =
      software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState.ACTIVE
  }
  case object blackhole extends zio.aws.ec2.model.LocalGatewayRouteState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState =
      software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState.BLACKHOLE
  }
  case object deleting extends zio.aws.ec2.model.LocalGatewayRouteState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState =
      software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState.DELETING
  }
  case object deleted extends zio.aws.ec2.model.LocalGatewayRouteState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState =
      software.amazon.awssdk.services.ec2.model.LocalGatewayRouteState.DELETED
  }
}
