package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LaunchPermission(
    group: Optional[zio.aws.ec2.model.PermissionGroup] = Optional.Absent,
    userId: Optional[String] = Optional.Absent,
    organizationArn: Optional[String] = Optional.Absent,
    organizationalUnitArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchPermission = {
    import LaunchPermission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchPermission
      .builder()
      .optionallyWith(group.map(value => value.unwrap))(_.group)
      .optionallyWith(userId.map(value => value: java.lang.String))(_.userId)
      .optionallyWith(organizationArn.map(value => value: java.lang.String))(
        _.organizationArn
      )
      .optionallyWith(
        organizationalUnitArn.map(value => value: java.lang.String)
      )(_.organizationalUnitArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LaunchPermission.ReadOnly =
    zio.aws.ec2.model.LaunchPermission.wrap(buildAwsValue())
}
object LaunchPermission {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchPermission
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchPermission =
      zio.aws.ec2.model.LaunchPermission(
        group.map(value => value),
        userId.map(value => value),
        organizationArn.map(value => value),
        organizationalUnitArn.map(value => value)
      )
    def group: Optional[zio.aws.ec2.model.PermissionGroup]
    def userId: Optional[String]
    def organizationArn: Optional[String]
    def organizationalUnitArn: Optional[String]
    def getGroup: ZIO[Any, AwsError, zio.aws.ec2.model.PermissionGroup] =
      AwsError.unwrapOptionField("group", group)
    def getUserId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userId", userId)
    def getOrganizationArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("organizationArn", organizationArn)
    def getOrganizationalUnitArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("organizationalUnitArn", organizationalUnitArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchPermission
  ) extends zio.aws.ec2.model.LaunchPermission.ReadOnly {
    override val group: Optional[zio.aws.ec2.model.PermissionGroup] =
      zio.aws.core.internal
        .optionalFromNullable(impl.group())
        .map(value => zio.aws.ec2.model.PermissionGroup.wrap(value))
    override val userId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => value: String)
    override val organizationArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationArn())
      .map(value => value: String)
    override val organizationalUnitArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationalUnitArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchPermission
  ): zio.aws.ec2.model.LaunchPermission.ReadOnly = new Wrapper(impl)
}
