package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait KeyFormat {
  def unwrap: software.amazon.awssdk.services.ec2.model.KeyFormat
}
object KeyFormat {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.KeyFormat
  ): zio.aws.ec2.model.KeyFormat = value match {
    case software.amazon.awssdk.services.ec2.model.KeyFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.KeyFormat.PEM =>
      val r = pem
      r
    case software.amazon.awssdk.services.ec2.model.KeyFormat.PPK =>
      val r = ppk
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.KeyFormat {
    override def unwrap: software.amazon.awssdk.services.ec2.model.KeyFormat =
      software.amazon.awssdk.services.ec2.model.KeyFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object pem extends zio.aws.ec2.model.KeyFormat {
    override def unwrap: software.amazon.awssdk.services.ec2.model.KeyFormat =
      software.amazon.awssdk.services.ec2.model.KeyFormat.PEM
  }
  case object ppk extends zio.aws.ec2.model.KeyFormat {
    override def unwrap: software.amazon.awssdk.services.ec2.model.KeyFormat =
      software.amazon.awssdk.services.ec2.model.KeyFormat.PPK
  }
}
