package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InternetGatewayAttachment(
    state: Optional[zio.aws.ec2.model.AttachmentStatus] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InternetGatewayAttachment = {
    import InternetGatewayAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InternetGatewayAttachment
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InternetGatewayAttachment.ReadOnly =
    zio.aws.ec2.model.InternetGatewayAttachment.wrap(buildAwsValue())
}
object InternetGatewayAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InternetGatewayAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InternetGatewayAttachment =
      zio.aws.ec2.model.InternetGatewayAttachment(
        state.map(value => value),
        vpcId.map(value => value)
      )
    def state: Optional[zio.aws.ec2.model.AttachmentStatus]
    def vpcId: Optional[String]
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.AttachmentStatus] =
      AwsError.unwrapOptionField("state", state)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InternetGatewayAttachment
  ) extends zio.aws.ec2.model.InternetGatewayAttachment.ReadOnly {
    override val state: Optional[zio.aws.ec2.model.AttachmentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.AttachmentStatus.wrap(value))
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InternetGatewayAttachment
  ): zio.aws.ec2.model.InternetGatewayAttachment.ReadOnly = new Wrapper(impl)
}
