package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{Integer, DateTime}
import scala.jdk.CollectionConverters._
final case class InstanceNetworkInterfaceAttachment(
    attachTime: Optional[DateTime] = Optional.Absent,
    attachmentId: Optional[String] = Optional.Absent,
    deleteOnTermination: Optional[Boolean] = Optional.Absent,
    deviceIndex: Optional[Integer] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.AttachmentStatus] = Optional.Absent,
    networkCardIndex: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAttachment = {
    import InstanceNetworkInterfaceAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAttachment
      .builder()
      .optionallyWith(attachTime.map(value => DateTime.unwrap(value): Instant))(
        _.attachTime
      )
      .optionallyWith(attachmentId.map(value => value: java.lang.String))(
        _.attachmentId
      )
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(deviceIndex.map(value => value: java.lang.Integer))(
        _.deviceIndex
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(networkCardIndex.map(value => value: java.lang.Integer))(
        _.networkCardIndex
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.InstanceNetworkInterfaceAttachment.ReadOnly =
    zio.aws.ec2.model.InstanceNetworkInterfaceAttachment.wrap(buildAwsValue())
}
object InstanceNetworkInterfaceAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceNetworkInterfaceAttachment =
      zio.aws.ec2.model.InstanceNetworkInterfaceAttachment(
        attachTime.map(value => value),
        attachmentId.map(value => value),
        deleteOnTermination.map(value => value),
        deviceIndex.map(value => value),
        status.map(value => value),
        networkCardIndex.map(value => value)
      )
    def attachTime: Optional[DateTime]
    def attachmentId: Optional[String]
    def deleteOnTermination: Optional[Boolean]
    def deviceIndex: Optional[Integer]
    def status: Optional[zio.aws.ec2.model.AttachmentStatus]
    def networkCardIndex: Optional[Integer]
    def getAttachTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("attachTime", attachTime)
    def getAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attachmentId", attachmentId)
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getDeviceIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("deviceIndex", deviceIndex)
    def getStatus: ZIO[Any, AwsError, zio.aws.ec2.model.AttachmentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNetworkCardIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("networkCardIndex", networkCardIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAttachment
  ) extends zio.aws.ec2.model.InstanceNetworkInterfaceAttachment.ReadOnly {
    override val attachTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.attachTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val attachmentId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.attachmentId())
      .map(value => value: String)
    override val deleteOnTermination: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteOnTermination())
      .map(value => value: Boolean)
    override val deviceIndex: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceIndex())
      .map(value => value: Integer)
    override val status: Optional[zio.aws.ec2.model.AttachmentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.AttachmentStatus.wrap(value))
    override val networkCardIndex: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.networkCardIndex())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAttachment
  ): zio.aws.ec2.model.InstanceNetworkInterfaceAttachment.ReadOnly =
    new Wrapper(impl)
}
