package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetInstanceUefiDataRequest(instanceId: InstanceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataRequest = {
    import GetInstanceUefiDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetInstanceUefiDataRequest.ReadOnly =
    zio.aws.ec2.model.GetInstanceUefiDataRequest.wrap(buildAwsValue())
}
object GetInstanceUefiDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetInstanceUefiDataRequest =
      zio.aws.ec2.model.GetInstanceUefiDataRequest(instanceId)
    def instanceId: InstanceId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataRequest
  ) extends zio.aws.ec2.model.GetInstanceUefiDataRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataRequest
  ): zio.aws.ec2.model.GetInstanceUefiDataRequest.ReadOnly = new Wrapper(impl)
}
