package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SnapshotId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EbsBlockDevice(
    deleteOnTermination: Optional[Boolean] = Optional.Absent,
    iops: Optional[Integer] = Optional.Absent,
    snapshotId: Optional[SnapshotId] = Optional.Absent,
    volumeSize: Optional[Integer] = Optional.Absent,
    volumeType: Optional[zio.aws.ec2.model.VolumeType] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    throughput: Optional[Integer] = Optional.Absent,
    outpostArn: Optional[String] = Optional.Absent,
    encrypted: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EbsBlockDevice = {
    import EbsBlockDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EbsBlockDevice
      .builder()
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(volumeSize.map(value => value: java.lang.Integer))(
        _.volumeSize
      )
      .optionallyWith(volumeType.map(value => value.unwrap))(_.volumeType)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(throughput.map(value => value: java.lang.Integer))(
        _.throughput
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EbsBlockDevice.ReadOnly =
    zio.aws.ec2.model.EbsBlockDevice.wrap(buildAwsValue())
}
object EbsBlockDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EbsBlockDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EbsBlockDevice =
      zio.aws.ec2.model.EbsBlockDevice(
        deleteOnTermination.map(value => value),
        iops.map(value => value),
        snapshotId.map(value => value),
        volumeSize.map(value => value),
        volumeType.map(value => value),
        kmsKeyId.map(value => value),
        throughput.map(value => value),
        outpostArn.map(value => value),
        encrypted.map(value => value)
      )
    def deleteOnTermination: Optional[Boolean]
    def iops: Optional[Integer]
    def snapshotId: Optional[SnapshotId]
    def volumeSize: Optional[Integer]
    def volumeType: Optional[zio.aws.ec2.model.VolumeType]
    def kmsKeyId: Optional[String]
    def throughput: Optional[Integer]
    def outpostArn: Optional[String]
    def encrypted: Optional[Boolean]
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getVolumeSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
    def getVolumeType: ZIO[Any, AwsError, zio.aws.ec2.model.VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getThroughput: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("throughput", throughput)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EbsBlockDevice
  ) extends zio.aws.ec2.model.EbsBlockDevice.ReadOnly {
    override val deleteOnTermination: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteOnTermination())
      .map(value => value: Boolean)
    override val iops: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: Integer)
    override val snapshotId: Optional[SnapshotId] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => zio.aws.ec2.model.primitives.SnapshotId(value))
    override val volumeSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeSize())
      .map(value => value: Integer)
    override val volumeType: Optional[zio.aws.ec2.model.VolumeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeType())
        .map(value => zio.aws.ec2.model.VolumeType.wrap(value))
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val throughput: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.throughput())
      .map(value => value: Integer)
    override val outpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => value: String)
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EbsBlockDevice
  ): zio.aws.ec2.model.EbsBlockDevice.ReadOnly = new Wrapper(impl)
}
