package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DnsOptions(
    dnsRecordIpType: Optional[zio.aws.ec2.model.DnsRecordIpType] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.DnsOptions = {
    import DnsOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DnsOptions
      .builder()
      .optionallyWith(dnsRecordIpType.map(value => value.unwrap))(
        _.dnsRecordIpType
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DnsOptions.ReadOnly =
    zio.aws.ec2.model.DnsOptions.wrap(buildAwsValue())
}
object DnsOptions {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.DnsOptions] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DnsOptions =
      zio.aws.ec2.model.DnsOptions(dnsRecordIpType.map(value => value))
    def dnsRecordIpType: Optional[zio.aws.ec2.model.DnsRecordIpType]
    def getDnsRecordIpType
        : ZIO[Any, AwsError, zio.aws.ec2.model.DnsRecordIpType] =
      AwsError.unwrapOptionField("dnsRecordIpType", dnsRecordIpType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DnsOptions
  ) extends zio.aws.ec2.model.DnsOptions.ReadOnly {
    override val dnsRecordIpType: Optional[zio.aws.ec2.model.DnsRecordIpType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsRecordIpType())
        .map(value => zio.aws.ec2.model.DnsRecordIpType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DnsOptions
  ): zio.aws.ec2.model.DnsOptions.ReadOnly = new Wrapper(impl)
}
