package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitGatewayAttachmentId,
  TransitGatewayRouteTableId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateTransitGatewayRouteTableRequest(
    transitGatewayRouteTableId: TransitGatewayRouteTableId,
    transitGatewayAttachmentId: TransitGatewayAttachmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableRequest = {
    import DisassociateTransitGatewayRouteTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableRequest
      .builder()
      .transitGatewayRouteTableId(
        TransitGatewayRouteTableId.unwrap(
          transitGatewayRouteTableId
        ): java.lang.String
      )
      .transitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transitGatewayAttachmentId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateTransitGatewayRouteTableRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateTransitGatewayRouteTableRequest
      .wrap(buildAwsValue())
}
object DisassociateTransitGatewayRouteTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisassociateTransitGatewayRouteTableRequest =
      zio.aws.ec2.model.DisassociateTransitGatewayRouteTableRequest(
        transitGatewayRouteTableId,
        transitGatewayAttachmentId
      )
    def transitGatewayRouteTableId: TransitGatewayRouteTableId
    def transitGatewayAttachmentId: TransitGatewayAttachmentId
    def getTransitGatewayRouteTableId
        : ZIO[Any, Nothing, TransitGatewayRouteTableId] =
      ZIO.succeed(transitGatewayRouteTableId)
    def getTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transitGatewayAttachmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableRequest
  ) extends zio.aws.ec2.model.DisassociateTransitGatewayRouteTableRequest.ReadOnly {
    override val transitGatewayRouteTableId: TransitGatewayRouteTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayRouteTableId(impl.transitGatewayRouteTableId())
    override val transitGatewayAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.transitGatewayAttachmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableRequest
  ): zio.aws.ec2.model.DisassociateTransitGatewayRouteTableRequest.ReadOnly =
    new Wrapper(impl)
}
