package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DhcpConfiguration(
    key: Optional[String] = Optional.Absent,
    values: Optional[Iterable[zio.aws.ec2.model.AttributeValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DhcpConfiguration = {
    import DhcpConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DhcpConfiguration
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DhcpConfiguration.ReadOnly =
    zio.aws.ec2.model.DhcpConfiguration.wrap(buildAwsValue())
}
object DhcpConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DhcpConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DhcpConfiguration =
      zio.aws.ec2.model.DhcpConfiguration(
        key.map(value => value),
        values.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def key: Optional[String]
    def values: Optional[List[zio.aws.ec2.model.AttributeValue.ReadOnly]]
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getValues
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.AttributeValue.ReadOnly]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DhcpConfiguration
  ) extends zio.aws.ec2.model.DhcpConfiguration.ReadOnly {
    override val key: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => value: String)
    override val values
        : Optional[List[zio.aws.ec2.model.AttributeValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AttributeValue.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DhcpConfiguration
  ): zio.aws.ec2.model.DhcpConfiguration.ReadOnly = new Wrapper(impl)
}
