package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTransitGatewayPeeringAttachmentsResponse(
    transitGatewayPeeringAttachments: Optional[
      Iterable[zio.aws.ec2.model.TransitGatewayPeeringAttachment]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse = {
    import DescribeTransitGatewayPeeringAttachmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse
      .builder()
      .optionallyWith(
        transitGatewayPeeringAttachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayPeeringAttachments)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse
      .wrap(buildAwsValue())
}
object DescribeTransitGatewayPeeringAttachmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse =
      zio.aws.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse(
        transitGatewayPeeringAttachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def transitGatewayPeeringAttachments: Optional[
      List[zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getTransitGatewayPeeringAttachments: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayPeeringAttachments",
      transitGatewayPeeringAttachments
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse
  ) extends zio.aws.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse.ReadOnly {
    override val transitGatewayPeeringAttachments: Optional[
      List[zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayPeeringAttachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TransitGatewayPeeringAttachment.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse
  ): zio.aws.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse.ReadOnly =
    new Wrapper(impl)
}
