package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeNetworkInsightsAccessScopesResponse(
    networkInsightsAccessScopes: Optional[
      Iterable[zio.aws.ec2.model.NetworkInsightsAccessScope]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesResponse = {
    import DescribeNetworkInsightsAccessScopesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesResponse
      .builder()
      .optionallyWith(
        networkInsightsAccessScopes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInsightsAccessScopes)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesResponse
      .wrap(buildAwsValue())
}
object DescribeNetworkInsightsAccessScopesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesResponse =
      zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesResponse(
        networkInsightsAccessScopes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networkInsightsAccessScopes
        : Optional[List[zio.aws.ec2.model.NetworkInsightsAccessScope.ReadOnly]]
    def nextToken: Optional[String]
    def getNetworkInsightsAccessScopes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.NetworkInsightsAccessScope.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "networkInsightsAccessScopes",
      networkInsightsAccessScopes
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesResponse
  ) extends zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesResponse.ReadOnly {
    override val networkInsightsAccessScopes: Optional[
      List[zio.aws.ec2.model.NetworkInsightsAccessScope.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInsightsAccessScopes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.NetworkInsightsAccessScope.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesResponse
  ): zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesResponse.ReadOnly =
    new Wrapper(impl)
}
