package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeHostReservationsResponse(
    hostReservationSet: Optional[Iterable[zio.aws.ec2.model.HostReservation]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse = {
    import DescribeHostReservationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse
      .builder()
      .optionallyWith(
        hostReservationSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hostReservationSet)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeHostReservationsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeHostReservationsResponse.wrap(buildAwsValue())
}
object DescribeHostReservationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeHostReservationsResponse =
      zio.aws.ec2.model.DescribeHostReservationsResponse(
        hostReservationSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def hostReservationSet
        : Optional[List[zio.aws.ec2.model.HostReservation.ReadOnly]]
    def nextToken: Optional[String]
    def getHostReservationSet
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.HostReservation.ReadOnly]] =
      AwsError.unwrapOptionField("hostReservationSet", hostReservationSet)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse
  ) extends zio.aws.ec2.model.DescribeHostReservationsResponse.ReadOnly {
    override val hostReservationSet
        : Optional[List[zio.aws.ec2.model.HostReservation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostReservationSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.HostReservation.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse
  ): zio.aws.ec2.model.DescribeHostReservationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
