package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, HostReservationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeHostReservationsRequest(
    filter: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    hostReservationIdSet: Optional[Iterable[HostReservationId]] =
      Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest = {
    import DescribeHostReservationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest
      .builder()
      .optionallyWith(
        filter.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filter)
      .optionallyWith(
        hostReservationIdSet.map(value =>
          value.map { item =>
            HostReservationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hostReservationIdSet)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeHostReservationsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeHostReservationsRequest.wrap(buildAwsValue())
}
object DescribeHostReservationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeHostReservationsRequest =
      zio.aws.ec2.model.DescribeHostReservationsRequest(
        filter.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hostReservationIdSet.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filter: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def hostReservationIdSet: Optional[List[HostReservationId]]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def getFilter: ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filter", filter)
    def getHostReservationIdSet: ZIO[Any, AwsError, List[HostReservationId]] =
      AwsError.unwrapOptionField("hostReservationIdSet", hostReservationIdSet)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest
  ) extends zio.aws.ec2.model.DescribeHostReservationsRequest.ReadOnly {
    override val filter: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val hostReservationIdSet: Optional[List[HostReservationId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostReservationIdSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.HostReservationId(item)
          }.toList
        )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest
  ): zio.aws.ec2.model.DescribeHostReservationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
