package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeFleetsResponse(
    nextToken: Optional[String] = Optional.Absent,
    fleets: Optional[Iterable[zio.aws.ec2.model.FleetData]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFleetsResponse = {
    import DescribeFleetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFleetsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        fleets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fleets)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeFleetsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeFleetsResponse.wrap(buildAwsValue())
}
object DescribeFleetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFleetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFleetsResponse =
      zio.aws.ec2.model.DescribeFleetsResponse(
        nextToken.map(value => value),
        fleets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def fleets: Optional[List[zio.aws.ec2.model.FleetData.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFleets
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.FleetData.ReadOnly]] =
      AwsError.unwrapOptionField("fleets", fleets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFleetsResponse
  ) extends zio.aws.ec2.model.DescribeFleetsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val fleets: Optional[List[zio.aws.ec2.model.FleetData.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.FleetData.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFleetsResponse
  ): zio.aws.ec2.model.DescribeFleetsResponse.ReadOnly = new Wrapper(impl)
}
