package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeElasticGpusResponse(
    elasticGpuSet: Optional[Iterable[zio.aws.ec2.model.ElasticGpus]] =
      Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeElasticGpusResponse = {
    import DescribeElasticGpusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeElasticGpusResponse
      .builder()
      .optionallyWith(
        elasticGpuSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticGpuSet)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeElasticGpusResponse.ReadOnly =
    zio.aws.ec2.model.DescribeElasticGpusResponse.wrap(buildAwsValue())
}
object DescribeElasticGpusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeElasticGpusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeElasticGpusResponse =
      zio.aws.ec2.model.DescribeElasticGpusResponse(
        elasticGpuSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def elasticGpuSet: Optional[List[zio.aws.ec2.model.ElasticGpus.ReadOnly]]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def getElasticGpuSet
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ElasticGpus.ReadOnly]] =
      AwsError.unwrapOptionField("elasticGpuSet", elasticGpuSet)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeElasticGpusResponse
  ) extends zio.aws.ec2.model.DescribeElasticGpusResponse.ReadOnly {
    override val elasticGpuSet
        : Optional[List[zio.aws.ec2.model.ElasticGpus.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticGpuSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ElasticGpus.wrap(item)
          }.toList
        )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeElasticGpusResponse
  ): zio.aws.ec2.model.DescribeElasticGpusResponse.ReadOnly = new Wrapper(impl)
}
