package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeClientVpnRoutesResponse(
    routes: Optional[Iterable[zio.aws.ec2.model.ClientVpnRoute]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesResponse = {
    import DescribeClientVpnRoutesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesResponse
      .builder()
      .optionallyWith(
        routes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeClientVpnRoutesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeClientVpnRoutesResponse.wrap(buildAwsValue())
}
object DescribeClientVpnRoutesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeClientVpnRoutesResponse =
      zio.aws.ec2.model.DescribeClientVpnRoutesResponse(
        routes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def routes: Optional[List[zio.aws.ec2.model.ClientVpnRoute.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getRoutes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ClientVpnRoute.ReadOnly]] =
      AwsError.unwrapOptionField("routes", routes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesResponse
  ) extends zio.aws.ec2.model.DescribeClientVpnRoutesResponse.ReadOnly {
    override val routes
        : Optional[List[zio.aws.ec2.model.ClientVpnRoute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ClientVpnRoute.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesResponse
  ): zio.aws.ec2.model.DescribeClientVpnRoutesResponse.ReadOnly = new Wrapper(
    impl
  )
}
